/*
 * File:	mcf5282_lo.s
 * Purpose:	Lowest level routines for the MCF5282.
 *
 * Notes:	
 */

#ifdef _UNDERSCORE_
#define mcf5282_init		_mcf5282_init
#define main				_main
#endif
 
	.extern ___IPSBAR
	.extern ___SRAM
	.extern ___FLASH
	.extern ___SP_INIT
	.extern ___SRAM_SIZE
	.extern mcf5xxx_wr_rambar0
	.extern mcf5xxx_wr_rambar1
	.extern mcf5282_init
	.extern main

	.global asm_startmeup
	.global _asm_startmeup
	.global cpu_cache_flush
	.global _cpu_cache_flush


	.text

/********************************************************************
 * This is the main entry point upon hard reset.
 */
asm_startmeup:
_asm_startmeup:

	/* Initialize IPSBAR */
	move.l	#(___IPSBAR + 1),d0
	move.l	d0,0x40000000
	
	/* Initialize FLASHBAR: locate internal Flash and validate it */
	move.l	#(___FLASH + 0x21),d0
    .long   0x4e7b0C04      /* movec d0,RAMBAR0	*/

	/* Initialize RAMBAR1: locate SRAM and validate it */
	move.l	#(___SRAM + 0x21),d0
    .long   0x4e7b0C05      /* movec d0,RAMBAR1	*/

	/* Point Stack Pointer into SRAM temporarily */
	move.l	#(___SRAM + 0x10000),sp

	/* Initialize mcf5282 periphs, etc */
	jsr		mcf5282_init

	/* Relocate Stack Pointer */ 
	move.l	#___SP_INIT,sp

	/* Jump to the main process */
	jmp		main
	
	bra		.
	nop
	nop
	halt

/********************************************************************
 * The MCF5282 cache can be configured as instruction, data or split.
 * Invalidate the entire cache.
 */
cpu_cache_flush:
_cpu_cache_flush:
	nop						/* sync */
	move.l	#0x01000000,d0	/* Invalidate the I-Cache */
	movec 	d0,cacr
	rts

	.end
